from django.db import migrations


def create_initial_roles(apps, schema_editor):
    UserRole = apps.get_model('users', 'UserRole')
    Department = apps.get_model('users', 'Department')
    
    # Create default roles
    roles = [
        ('president', 'President'),
        ('minister', 'Minister'),
        ('director', 'Director General'),
        ('head', 'Head of Section'),
        ('secretary', 'Secretary')
    ]
    
    # Create roles if they don't exist
    for role_value, role_display in roles:
        UserRole.objects.get_or_create(
            name=role_value,
            defaults={'name': role_value}
        )
    
    # Create a default department if none exists
    Department.objects.get_or_create(
        name='Administration',
        defaults={
            'description': 'Default administration department',
            'parent': None
        }
    )


class Migration(migrations.Migration):

    dependencies = [
        ('users', '0002_user_phone_number_alter_user_date_joined_and_more'),
    ]

    operations = [
        migrations.RunPython(create_initial_roles, migrations.RunPython.noop),
    ]
